/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.turtle.core.TurtleCraftCommand;
import java.util.Optional;
import javax.annotation.Nonnull;

public class CraftingTablePeripheral
implements IPeripheral {
    private final ITurtleAccess turtle;

    public CraftingTablePeripheral(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    @Override
    @Nonnull
    public String getType() {
        return "workbench";
    }

    @LuaFunction
    public final MethodResult craft(Optional<Integer> count) throws LuaException {
        int limit = count.orElse(64);
        if (limit < 0 || limit > 64) {
            throw new LuaException("Crafting count " + limit + " out of range");
        }
        return this.turtle.executeCommand(new TurtleCraftCommand(limit));
    }

    @Override
    public boolean equals(IPeripheral other) {
        return other instanceof CraftingTablePeripheral;
    }

    @Override
    @Nonnull
    public Object getTarget() {
        return this.turtle;
    }
}

